﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace wol
{
	/// <summary>
	/// This class provides methods to separate xml names from delimiters, such as {}.
	/// </summary>
	internal class XmlHelp
	{
		/// <summary>
		/// Compare the name of an element, implicitly using the {} delimiters for the namespace.
		/// </summary>
		/// <param name="element">the element whose name is to be compared</param>
		/// <param name="space">the namespace name, without {}, to which to compare the element name</param>
		/// <param name="name">the local name, to which to compare the element name</param>
		/// <returns>whether the result of comparison is equality</returns>
		public static bool ElementIs(XElement element, string space, string name)
		{
			return ((element.Name.Namespace.ToString() == space) && (element.Name.LocalName == name));
		}

		/// <summary>
		/// Compare the name of an element, implicitly using the {} delimiters for the namespace.
		/// </summary>
		/// <param name="element">the element whose name is to be compared</param>
		/// <param name="name">the local name, to which to compare the element name</param>
		/// <returns>whether the result of comparison is equality</returns>
		public static bool ElementIs(XElement element, string name)
		{
			return (element.Name.LocalName == name);
		}

		/// <summary>
		/// Extract an attribute from an element, implicitly using the {} delimiters for the namespace.
		/// </summary>
		/// <param name="element">the element whose attribute is wanted</param>
		/// <param name="space">the namespace name, without {}, for the attribute</param>
		/// <param name="name">the local name for the attribute</param>
		/// <returns></returns>
		public static XAttribute AttributeOf(XElement element, string space, string name)
		{
			return element.Attribute("{" + space + "}" + name);
		}
	}
}
